#include<NTPClient.h>
#include<ESP8266WiFi.h>
#include<WiFiUdp.h>
#include<OneWire.h>
#include<DallasTemperature.h>
#include<DFRobot_DHT11.h>
#include<DHT.h>
const char* ssid = "********";
const char* pass = "********";
const long utcOffsetInSeconds = 19800; // IST = UTC +5:30 that is [(5*60)+30]*60 sec
WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP, "pool.ntp.org", utcOffsetInSeconds);
DFRobot_DHT11 DHT;
#define DHT11_PIN D2 // pin D2 for DHT11
const int oneWireBus = D3; // pin D3 for ds18b20
int temp;
OneWire oneWire(oneWireBus);
DallasTemperature sensors(&oneWire);
void setup()
{
  Serial.begin(115200);
pinMode(D2,INPUT); // DHT11
pinMode(D3,INPUT); // DS18B20
pinMode(D4,OUTPUT); // Relay
digitalWrite(D4,HIGH); // Initialize relay in off mode (ESP issue Low High Invert)
WiFi.begin(ssid, pass); // User’s set of SSID and Password
while(WiFi.status()!=WL_CONNECTED)
{
delay(500);
Serial.print(".");
}
timeClient.begin();
}
void loop()
{
// DHT11
DHT.read(DHT11_PIN);
Serial.print("Temperature : ");
Serial.print(DHT.temperature);
temp=DHT.temperature;
Serial.print(" Humidity : ");
Serial.println(DHT.humidity);
// DS18B20
sensors.requestTemperatures();
float temperatureC = sensors.getTempCByIndex(0);
Serial.print("Water Temperature : ");
Serial.print(sensors.getTempCByIndex(0));
Serial.println(" oC");
// Time
timeClient.update();
Serial.print(timeClient.getHours());
Serial.print(":");
Serial.print(timeClient.getMinutes());
Serial.print(":");
Serial.println(timeClient.getSeconds());
// Relay
if(timeClient.getHours()==16 && timeClient.getMinutes()==0) // check for the 16:00 HH:MM
{
digitalWrite(D4, LOW);
Serial.println("Fogger is on");
delay(30000);
digitalWrite(D4, HIGH);
Serial.println("Fogger is off");
delay(40000);
}
delay(2000);
}